﻿var interviewer = {
    context: $(".v-interviewer"),
    datatable: null,
    fileManagementId: $("#FileManagementId").val(),
    deletedInterviewers: [],
    initialize: function () {
        interviewer.datatable = $(".h-interviewerTable").a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetCAPISentFileInterviewers", "MultiMode", "Settings"),
            ajaxParams: { "fileManagementId": interviewer.fileManagementId },
            displayLength: 10,
            displayColumnSelector: false,
            displaySearchBox: false,
            allowRowSelection: true,
            columns: [
                { "Name": "Id", "Visible": false, "Type": "numeric" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "DateSent", "Title": resources.DateSent, "Data": "DateSent" }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        interviewer.updateDeleteInterviewer(row.Id);
                        break;
                }
                
            },
            toolBarItems: [
                { "Action": "add", "Label": resources.AddInterviewers, "DisplayMode": dataTables.itemDisplayMode.always },
                { "Action": "delete", "Label": resources.Delete }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                
                switch (action) {
                    case "add":
                        modalDialog.showWindow(a4.getAction("AddInterviewers", "MultiMode", "Settings", { fileManagementId: interviewer.fileManagementId }), 500, 800, { afterClose: function () { interviewer.refreshContent(); } });
                        break;
                    case "delete":
                        interviewer.updateDeleteInterviewers();
                        break;
                };
            }
        });
    },
    refreshContent: function () {
        var paramFileManagement = {
            "fileManagementId": interviewer.fileManagementId,
            "groupIds": $("#GroupIds").val(),
            "userIds": $("#UserIds").val(),
            "projectIds": $("#ProjectIds").val(),
            "moduleIds": $("#ModuleIds").val(),
            "deletedIds": $("#DeletedIds").val()
        };

        interviewer.datatable.a4datatable("option", "ajaxParams", paramFileManagement);
        interviewer.datatable.a4datatable("refresh", true);
    },
    updateDeleteInterviewer: function (interviewerId) {
        interviewer.deletedInterviewers.push(interviewerId);
        interviewer.updateModulesInput();
        interviewer.refreshContent();
    },
    updateDeleteInterviewers: function () {
        var rows = interviewer.datatable.a4datatable("getSelectedItems");
        _.each(rows, function (row) {
            interviewer.deletedInterviewers.push(row.Id);
        });
        interviewer.updateModulesInput();
        interviewer.refreshContent();
    },
    updateModulesInput: function() {
        $("#DeletedIds", interviewer.context).val(interviewer.deletedInterviewers.join(","));
    },
}

var interviewerAssignment = {
    context: $(".v-interviewerAssignment"),
    datatable: null,
    fileManagementId: $("#FileManagementId").val(),
    selectedGroups: [],
    selectedUsers: [],
    selectedProjects: [],
    selectedModules: [],
    CAPI_MODULE: 3,
    initialize: function () {
        $(".v-moduleEditorTabs", this.context).a4tabs({
            load: function (e, d) {
                if (d.id == "users") {
                    interviewerAssignment.initializeTreeView(d.tab);
                }
                else if (d.id == "projects") {
                    interviewerAssignment.initializeProjectTreeView(d.tab);
                }
            }
        });
        a4.initializeInputs(this.context);

        a4.setInputFocus(this.context);
    },
    initializeTreeView: function (tab) {
        interviewerAssignment.groupsListView = $(".h-userGroups", tab).a4listview({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings", { hasUsersOnly: true }),
            draw: function (event, data) {
                var group = data.selectedNode;
                var groupId = group ? group.Id : null;

                if (interviewerAssignment.usersDatatable) {
                    interviewerAssignment.usersDatatable.a4datatable("option", "ajaxParams", { "groupId": groupId });
                    interviewerAssignment.usersDatatable.a4datatable("refresh");
                }
                else {
                    interviewerAssignment.initializeUsersDataTable(tab, groupId);
                }
            },
            actionButtons: [
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-unchecked",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isGroupActionVisible(data.Id, data.Users, 'unchecked'); }
                },
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-partial",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isGroupActionVisible(data.Id, data.Users, 'partial'); }
                },
                {
                    Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isGroupActionVisible(data.Id, data.Users, 'checked'); }
                }
            ],
            actionButtonClick: function (event, data) {
                switch (data.action) {
                    case "select":
                        interviewerAssignment.selectedGroups.push(data.node.Id);
                        break;
                    case "unselect":
                        interviewerAssignment.selectedGroups = _.without(interviewerAssignment.selectedGroups, data.node.Id);
                        break;
                }

                $(this).a4listview("evaluateActionsConditions", data.node.ListView_Internal_Key);

                interviewerAssignment.updateGroupsInput();
            },
            displayActionButtonsOnLeft: true,
            displayActionButtonsOnHover: false,
            icons: null,
            highlightFirstNode: true,
            selectNode: function (event, data) {
                var tableParams = {
                    groupId: data.node ? data.node.Id : null,
                    unassigned: null
                };

                interviewerAssignment.usersDatatable.a4datatable("option", "ajaxParams", tableParams);
                interviewerAssignment.usersDatatable.a4datatable("refresh", true);
            }

        });
    },
    initializeUsersDataTable: function (tab, groupId) {
        interviewerAssignment.usersDatatable = $(".h-usersTable", tab).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetUsers", "Users", "Settings"),
            ajaxParams: { "groupId": groupId },
            altValueField: $("#userIds"),
            displayLength: 10,
            allowRowSelection: true,
            displayColumnSelector: false,
            columns: [
                { "Name": "ExternalId", "Visible": false, "Type": "numeric", "Key": true },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "Class": "v-name" },
                { "Name": "Firstname", "Title": resources.FirstName, "Data": "Firstname" },
                { "Name": "Lastname", "Title": resources.LastName, "Data": "Lastname" }
            ],
            defaultSorting: "UserName",
            selectedRows: interviewerAssignment.selectedUsers,
            rememberRowSelection: true,
            selectRow: function (e, d) {
                var externalIds = _.pluck(d.data, "ExternalId");

                if (d.isChecked) {
                    interviewerAssignment.selectedUsers = _.union(interviewerAssignment.selectedUsers, externalIds);
                }
                else {
                    interviewerAssignment.selectedUsers = _.difference(interviewerAssignment.selectedUsers, externalIds);
                }
                interviewerAssignment.groupsListView.a4listview("evaluateActionsConditions");
                interviewerAssignment.updateUsersInput();
            }
        });
    },
    initializeProjectTreeView: function (tab) {
        interviewerAssignment.projectsListView = $(".h-Projects", tab).a4listview({
            ajaxAction: a4.getAction("GetCAPIProjects", "Home", "Project"),
            draw: function (event, data) {
                var project = data.selectedNode;
                var projectId = project ? project.Id : null;
                
                if (interviewerAssignment.modulesDatatable) {
                    interviewerAssignment.modulesDatatable.a4datatable("option", "ajaxParams", { "projectId": projectId });
                    interviewerAssignment.modulesDatatable.a4datatable("refresh");
                }
                else {
                    interviewerAssignment.initializeModulesDataTable(tab, projectId);
                }

            },
            actionButtons: [
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-unchecked",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isProjectActionVisible(data.Id, data.Modules, 'unchecked'); }
                },
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-partial",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isProjectActionVisible(data.Id, data.Modules, 'partial'); }
                },
                {
                    Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked",
                    DisplayCondition: function (data) { return data.Id && interviewerAssignment.isProjectActionVisible(data.Id, data.Modules, 'checked'); }
                }
            ],
            actionButtonClick: function (event, data) {
                switch (data.action) {
                    case "select":
                        interviewerAssignment.selectedProjects.push(data.node.Id);
                        break;
                    case "unselect":
                        interviewerAssignment.selectedProjects = _.without(interviewerAssignment.selectedProjects, data.node.Id);
                        break;
                }

                $(this).a4listview("evaluateActionsConditions", data.node.ListView_Internal_Key);
                interviewerAssignment.projectsListView.a4listview("evaluateActionsConditions");
                interviewerAssignment.updateProjectsInput();
            },
            displayActionButtonsOnLeft: true,
            displayActionButtonsOnHover: false,
            icons: null,
            highlightFirstNode: true,
            selectNode: function (event, data) {
                var tableParams = {
                    projectId: data.node ? data.node.Id : null
                };
                
                interviewerAssignment.modulesDatatable.a4datatable("option", "ajaxParams", tableParams);
                interviewerAssignment.modulesDatatable.a4datatable("refresh", true);
            }
        });
    },
    initializeModulesDataTable: function (tab, projectId) {
        interviewerAssignment.modulesDatatable = $(".h-modulesTable", tab).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetModules", "Modules", "Project", { type: interviewerAssignment.CAPI_MODULE }),
            ajaxParams: { "projectId": projectId },
            displayLength: 10,
            allowRowSelection: true,
            displayColumnSelector: false,
            columns: [
                { "Title": resources.Id, "Data": "Id", "Key": true, "Type": "numeric" },
                { "Title": resources.Name, "Data": "Name", "Class": "itemName", "HideInSelector": true },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" },
                { "Name": "Type", "Title": resources.Type, "Data": "TypeLabel", "Type": "enum" }
            ],
            defaultSorting: "Name",
            selectedRows: interviewerAssignment.selectedModules,
            rememberRowSelection: true,
            selectRow: function (e, d) {
                var ids = _.pluck(d.data, "Id");

                if (d.isChecked) {
                    interviewerAssignment.selectedModules = _.union(interviewerAssignment.selectedModules, ids);
                }
                else {
                    interviewerAssignment.selectedModules = _.difference(interviewerAssignment.selectedModules, ids);
                }
                interviewerAssignment.projectsListView.a4listview("evaluateActionsConditions");
                interviewerAssignment.updateModulesInput();
            }
            
        });
    },
    bindEvents: function () {
        $(".h-submit", interviewerAssignment.context).on("click", function () {
            modalDialog.close();
        });
        $(".h-cancel", interviewerAssignment.context).on("click", function () {
            interviewerAssignment.resetSelectedValues();
            modalDialog.close();
        });
    },
    updateGroupsInput: function () {
        $("#GroupIds", a4.parent().interviewer.context).val(interviewerAssignment.selectedGroups.join(","));
    },
    updateUsersInput: function () {
        $("#UserIds", a4.parent().interviewer.context).val(interviewerAssignment.selectedUsers.join(","));
    },
    updateProjectsInput: function () {
        $("#ProjectIds", a4.parent().interviewer.context).val(interviewerAssignment.selectedProjects.join(","));
    },
    updateModulesInput: function () {
        $("#ModuleIds", a4.parent().interviewer.context).val(interviewerAssignment.selectedModules.join(","));
    },
    resetSelectedValues : function() {
        $("#GroupIds", a4.parent().interviewer.context).val("");
        $("#UserIds", a4.parent().interviewer.context).val("");
        $("#ProjectIds", a4.parent().interviewer.context).val("");
        $("#ModuleIds", a4.parent().interviewer.context).val("");
    },
    isGroupSelected: function (groupId) {
        return _.contains(interviewerAssignment.selectedGroups, groupId);
    },
    isProjectSelected: function (projectId) {
        return _.contains(interviewerAssignment.selectedProjects, projectId);
    },
    isGroupActionVisible: function (groupId, users, action) {
        var groupIsSelected = _.contains(interviewerAssignment.selectedGroups, groupId);
        var usersAreSelected = !groupIsSelected && _.some(interviewerAssignment.selectedUsers, function (g) { return _.some(users, function (u) { return u.ExternalId == g }); });
        var visible = false;

        if (action == "unchecked")
            visible = !groupIsSelected && !usersAreSelected;
        else if (action == "checked")
            visible = groupIsSelected;
        else if (action == "partial")
            visible = usersAreSelected;

        return visible;
    },
    isProjectActionVisible: function (projectId, modules, action) {
        var projectIsSelected = _.contains(interviewerAssignment.selectedProjects, projectId);
        var modulesAreSelected = !projectIsSelected && _.some(interviewerAssignment.selectedModules, function (g) { return _.some(modules, function (u) { return u.Id == g }); });
        var visible = false;

        if (action == "unchecked")
            visible = !projectIsSelected && !modulesAreSelected;
        else if (action == "checked")
            visible = projectIsSelected;
        else if (action == "partial")
            visible = modulesAreSelected;

        return visible;
    }
};

$(document).ready(function () {
    if (interviewer.context.length > 0) {
        interviewer.initialize();
    }
    if (interviewerAssignment.context.length > 0) {
        interviewerAssignment.initialize();
        interviewerAssignment.bindEvents();
    }
});